<?php
/**
 * GeneratePress child theme functions and definitions.
 *
 * Add your custom PHP in this file. 
 * Only edit this file if you have direct access to it on your server (to fix errors if they happen).
 */

function generatepress_child_enqueue_scripts() {
	if ( is_rtl() ) {
		wp_enqueue_style( 'generatepress-rtl', trailingslashit( get_template_directory_uri() ) . 'rtl.css' );
	}
}
add_action( 'wp_enqueue_scripts', 'generatepress_child_enqueue_scripts', 100 );


add_filter('acf/settings/remove_wp_meta_box', '__return_false');

//merge tag
add_shortcode('Antwerpen', 'mailbox_gemeente');
function mailbox_gemeente(){
		
ob_start();	 
$gemeente = get_the_title();
echo $gemeente;
$sc = ob_get_contents();
ob_end_clean();

return $sc;
}

//set google maps api
// Method 2: Setting.
function my_acf_init() {
    acf_update_setting('google_api_key', 'AIzaSyC5mYxVGratgSFQFPd8p_xrGG1ovxcL2W0');
}
add_action('acf/init', 'my_acf_init');

//cpt gemeentes

function cw_post_type_gemeente() {
$supports = array(
'title', // post title
'editor', // post content
'author', // post author
'thumbnail', // featured images
'excerpt', // post excerpt
'custom-fields', // custom fields
'comments', // post comments
'revisions', // post revisions
'post-formats', // post formats
);
$labels = array(
'name' => _x('gemeentes', 'plural'),
'singular_name' => _x('gemeente', 'singular'),
'menu_name' => _x('gemeentes', 'admin menu'),
'name_admin_bar' => _x('nieuwe gemeente', 'admin bar'),
'add_new' => _x('Gemeente toevoegen', 'add new'),
'add_new_item' => __('Nieuwe gemeente toevoegen'),
'new_item' => __('Nieuwe gemeente'),
'edit_item' => __('Gemeente bewerken'),
'view_item' => __('Gemeente bekijken'),
'all_items' => __('Alle gemeentes'),
'search_items' => __('Gemeente zoeken'),
'not_found' => __('Geen gemeentes gevonden'),
);
$args = array(
'supports' => $supports,
'labels' => $labels,
'public' => true,
'query_var' => true,
'rewrite' => array('slug' => 'gemeente'),
'has_archive' => true,
'hierarchical' => false,
);
register_post_type('gemeente', $args);
}
add_action('init', 'cw_post_type_gemeente');

// language menu
add_shortcode('lang_menu', 'mailbox_show_lang_menu');
function mailbox_show_lang_menu(){
$translations = pll_the_languages( array( 'raw' => 1 ) );
ob_start();	
?>
<ul class="lang_menu">
	<?php
	if ($translations){
		foreach($translations as $translation){
			?>
			<li class="<?php echo $translation["current_lang"] ?>"><a href="<?php echo $translation["url"] ?>"><?php echo $translation["name"] ?></a></li>
			<?php
		}
	}
	?>
</ul>
<?php
$sc = ob_get_contents();
ob_end_clean();
		
return $sc;
}
